require "selenium-webdriver"
require "rspec"
require "./spec/spec_helper"
require_relative "../../pages/_config"
require "./pages/provider_login"
require "./pages/search"
include RSpec::Expectations


describe "Patient Search: PV-1439" do

  before(:all) do
    @driver = Selenium::WebDriver.for :firefox
    @base_url = $acp_url
    @wrapper_url = $acp_url + "/" + $acp_app
    @accept_next_alert = true
    @driver.manage.timeouts.implicit_wait = 3
    @verification_errors = []

    @login = ProviderLogin.new @driver
    @login.loginAsCprs1234()
            
    @driver.get(@wrapper_url)
    @search = Search.new(@driver)
  end
  
  after(:all) do
    @driver.quit
    @verification_errors.should == []
  end
  
  before(:each) do
    @driver.get(@wrapper_url)
  end
  
  describe "Patient Search by name and SSN: PV-1548" do

    it 'should display Patient Search in the search popup' do
      @search.searchByPatient('twelve')
      expect(@search.getSearchHeader()).to eq('Patient Search')
        
      @search.selectPatientAtRow(2)
      
      expect(@search.getPopupLastName()).to eq('Last TWELVE')
      expect(@search.getPopupFirstName()).to eq('First INPATIENT')
      expect(@search.getPopupSsn()).to eq('SSN 666-00-0812')
    end
      
     it 'should not display results if more than 40 returned' do
       @search.searchByPatient('one')
       expect(@search.getNoResultsFound()).to eq('Please refine your search criteria to decrease the size of the result set')
     end   
     
#    OBE 
#    it 'should initially display only 20 rows if the search is too broad' do
#      @search.searchByPatient('patient26')
#      expect(@search.getExpectedPatientAtRow(2,"patient26, zztest")).to be_true
#      expect(@search.getSearchResultsLength()).to eq(20)
#      expect(@search.getSearchResultDisplayCount()).to eq('Displaying 20 Results of 26 Total')
#    end

    it 'should display one patient with an exact match' do
      @search.searchByPatient('twelve, inpatient')
      expect(@search.getExpectedPatientAtRow(1,"TWELVE, INPATIENT")).to be_true
      expect(@search.getSearchResultsLength()).to eq(1)
    end

    it 'should display the patient by searching with only the SSN' do
      @search.searchByPatient('666-00-0812')
      expect(@search.getPatientNameAtRow(1)).to eq('TWELVE, INPATIENT')
    end

#    OBE - Do not support search by last 4 of SSN only. 
#    it 'should display a list of patients when searching with only the last four digits of the SSN' do
#      @search.searchByPatient('0812')
#      expect(@search.getSearchResultsLength()).to be > 0
#    end
    
    it 'should display Patient Twelve when searching with last initial and last for digits of SSN' do
      @search.searchByPatient('t0812')
      expect(@search.getExpectedPatientAtRow(1,"TWELVE, INPATIENT")).to be_true
      expect(@search.getSearchResultsLength()).to eq(1)
    end
    
    it 'should display a list of patients when searching on the last name' do
      @search.searchByPatient('twelve')
      expect(@search.getSearchResultsLength()).to be > 0
      expect(@search.getExpectedPatientAtRow(2,"TWELVE, INPATIENT")).to be_true
    end
 
    it 'should display no results when the search criteria does not find any patients' do
      @search.searchByPatient("\u070f\u17b4\u17b5!@\#$%^&*()_+=-~`")
      expect(@search.getNoResultsFound()).to eq('No Results Found')
    end

#    ToDo - need to find or create patient with an apostrophe in their name 
#    it 'should return results for patients with an apostrophe in their name' do
#      @search.searchByPatient("patient'69")
#      expect(@search.getExpectedPatientAtRow(2,"patient'69, zztest")).to be_true
#      expect(@search.getSearchResultsLength()).to eq(1)
#    end
    
    it 'should return results for patients with a hyphen in their name' do
      @search.searchByPatient("bcma,twenty-patient")
      expect(@search.getExpectedPatientAtRow(1,"BCMA, TWENTY-PATIENT")).to be_true
      expect(@search.getSearchResultsLength()).to eq(1)
    end

    it 'should return results for patients with a space in their name' do
      @search.searchByPatient("Bhiepatient, A One")
      expect(@search.getExpectedPatientAtRow(1,"BHIEPATIENT, A ONE")).to be_true
      expect(@search.getSearchResultsLength()).to eq(1)
    end

  end #close patient search describe block
  
end  